function [words_DR, MFs, Cs, Cl, Cr]=getFOUs_FLIA_weight1(ppmenu63string)

%% -- Read Data------------------------------
W = xlsread('data_thirdpart1_Left.xls'); %% read the data from the first part of the survey
[row, col] = size(W);

%% --- Input the names of words --------------
ppmenu63string;

MFs=zeros(col/2,9);
MeanOfLeftEnd=[]; %% mean of left-end
MeanOfRightEnd=[]; %% mean of right-end

%% ---- compute the FOUs and centroids --------------------
for i=1:col/2
    %%disp('This is for')
    %%disp(ppmenu61string(i,:))
    L = W(1:row, 2*i-1);  %%Read the left end points for interval data.
    R = W(1:row, 2*i);    %%Read the right end points for interval data.
    [MFs(i,:),n(i),Stat, NNum, Shift(i,:)] = Fuzzistics_FL1(L,R); %%Determine the interval type-2 MFs and the number of remaining interval data m* for each word.
    [Cs(i), Cl(i), Cr(i)]=centroid(MFs(i,:)); %%Compute the center of the centroid and the centroid of interval type-2 MFs.
end

%% -- sort the MFs in ascending order according to the center of centroid --
[Cs,index]=sort(Cs);  %% Sort the center of the centroid
MFs=MFs(index,:);     %% Reorder the MFs based on the sorting of the center of centroids
Cl=Cl(index);         %% Reorder the left end of the centroid.
Cr=Cr(index);         %% Reorder the right end of the centroid.
words_DR=ppmenu63string(index,:); %%Reorder the names of words.